#$Id$
require 'zoho_analytics_client'

class Config
  ORGID = "55522777"
  WORKSPACEID = "35130000001055707"
  VIEWID = "35730000007354002"
end

class Sample
  def initialize
    @ac = AnalyticsClient.new
           .with_data_center("US")
           .with_oauth({
             "clientId" => "1000.xxxxxxx",
             "clientSecret" => "xxxxxxx",
             "refreshToken" => "1000.xxxxxxx.xxxxxxx"
           })
           #.with_token_store_path("/home/admin/analytics_ruby_sdk/tokens") # Optional – specify a directory path to securely store the encrypted access token
           .build
  end

  def get_orgs
    result = @ac.get_orgs
    puts result
  end

  def get_workspaces
    result = @ac.get_workspaces
    puts result
  end

  def get_views
    workspace = @ac.get_workspace_instance(Config::ORGID, Config::WORKSPACEID)
    config = { 'viewTypes' => ['0'] }
    result = workspace.get_views(config)
    puts result
  end

  def add_row
    column_values = {
      "Region" => "East",
      "Product Category" => "Sample",
      "Product" => "Test"
    }

    view = @ac.get_view_instance(Config::ORGID, Config::WORKSPACEID, Config::VIEWID)
    result = view.add_row(column_values)
    puts result
  end

  def update_row
    column_values = {
      "Region" => "West",
      "Product Category" => "Fruits",
      "Product" => "Apple"
    }

    criteria = '"Sales"."Region"=\'East\''
    view = @ac.get_view_instance(Config::ORGID, Config::WORKSPACEID, Config::VIEWID)
    result = view.update_row(column_values, criteria)
    puts result
  end

  def delete_row
    criteria = '"Sales"."Region"=\'East\''
    view = @ac.get_view_instance(Config::ORGID, Config::WORKSPACEID, Config::VIEWID)
    result = view.delete_row(criteria)
    puts result
  end

  def export_data
    response_format = 'csv'
    file_path = '/home/admin/ruby/SalesData.csv'
    bulk = @ac.get_bulk_instance(Config::ORGID, Config::WORKSPACEID)

    config = {
      "criteria" => "\"Sales\".\"Region\"='East'"
    }

    bulk.export_data(Config::VIEWID, response_format, file_path, config)
    puts "success"
  end
 
  def import_data
    import_type = "append"
    file_type = "csv"
    auto_identify = "true"
    file_path = "/home/admin/ruby/SalesData.csv"
    
    bulk = @ac.get_bulk_instance(Config::ORGID, Config::WORKSPACEID)
    result = bulk.import_data(Config::VIEWID, import_type, file_type, auto_identify, file_path)
    
    puts result
  end
end

begin
  obj = Sample.new
  obj.add_row
rescue ServerError => e
  puts "Server Error: #{e.response_content}"
rescue StandardError => e
  puts e.message
  puts e.backtrace.join("\n")
end
